
surface cyslice_subd_matte( 
	float 	Ka 						= 0;
	float 	Kd 						= 1;
	string	cyslice_subd_color 		= "";
	float	cyslice_subd_uvgrid		= 0 )
{
    normal 	Nf 						= faceforward( normalize( N), I);

	if( cyslice_subd_color != "")
	{
		Ci  = 
			color
			/*
			texture( 
				cyslice_subd_color, 
				s,
				t,
				"swidth", 0.0001,
				"twidth", 0.0001,
				"samples", 1);
			*/
			texture( 
				cyslice_subd_color, 
				s,
				t);
	}
	else
	{
		Ci  = Cs;
	}

	if( cyslice_subd_uvgrid > 0)
	{
		float   map_u,
				map_v,
				mult;   	

		map_u   = smoothstep( 0.0, 1.25 * du, abs( (u * 1.0) - round( u * 1.0)));
		map_v   = smoothstep( 0.0, 1.25 * dv, abs( (v * 1.0) - round( v * 1.0)));

		mult	= min( map_u, map_v);

		Ci  	= (color( 0, 0, 0) * (1 - mult)) + (Ci * mult);  		
	}

    Oi = Os;
    Ci = Oi * Ci * ((Ka * ambient()) + (Kd * diffuse( Nf)));
}

